/*
 * Decompiled with CFR 0.152.
 */
package cn.bjsxt.plane;

import cn.bjsxt.plane.Bullet;
import cn.bjsxt.plane.Explode;
import cn.bjsxt.plane.Plane;
import cn.bjsxt.util.GameUtil;
import cn.bjsxt.util.MyFrame;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Date;

public class PlaneGameFrame
extends MyFrame {
    private static final long serialVersionUID = 1L;
    Image bg = GameUtil.getImage("images/bg.jpg");
    Plane p = new Plane("images/plane.png", 50.0, 50.0);
    ArrayList bulletList = new ArrayList();
    Explode bao;
    Date startTime;
    Date endTime;

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.bg, 0, 0, null);
        this.p.draw(g);
        int i = 0;
        while (i < this.bulletList.size()) {
            Bullet b = (Bullet)this.bulletList.get(i);
            b.draw(g);
            boolean peng = b.getRect().intersects(this.p.getRect());
            if (peng) {
                this.p.setLive(false);
                if (this.bao == null) {
                    this.endTime = new Date();
                    this.bao = new Explode(this.p.x, this.p.y);
                }
                this.bao.draw(g);
            }
            ++i;
        }
        if (!this.p.isLive()) {
            this.printInfo(g, "\u5144\u5f1f\u5c31\u6b7b\u4e86\u7684\u561b", 50, 150, 200);
            int period = (int)((this.endTime.getTime() - this.startTime.getTime()) / 1000L);
            this.printInfo(g, "\u4f60\u7684\u6301\u4e45\u5ea6\u624d" + period + "\u79d2", 50, 150, 250);
            switch (period / 10) {
                case 0: {
                    this.printInfo(g, "\u771f.\u5934\u9876\u4e00\u7247\u9752\u9752\u8349\u539f", 50, 150, 300);
                    break;
                }
                case 1: {
                    this.printInfo(g, "\u8fd9\u4e1c\u897f\u4f60\u4e5f\u8981\u62a2\u7740\u5e26\uff1f", 50, 150, 300);
                    break;
                }
                case 2: {
                    this.printInfo(g, "\u5982\u679c\u68a6\u60f3\u6709\u989c\u8272\uff0c\u90a3\u4e00\u5b9a\u662f\u539f\u8c05\u8272", 40, 30, 300);
                    break;
                }
                case 3: {
                    this.printInfo(g, "\u54df\uff0c\u708a\u4e8b\u73ed\u957f\u5440\u5144\u5f1f", 50, 150, 300);
                    break;
                }
                case 4: {
                    this.printInfo(g, "\u52a0\u6cb9\u4f60\u5c31\u662f\u4e0b\u4e00\u4e2a\u8001\u738b", 50, 150, 300);
                    break;
                }
                case 5: {
                    this.printInfo(g, "\u5982\u679c\u6491\u8fc7\u4e00\u5206\u949f\u6211\u5c82\u4e0d\u662f\u5f88\u6ca1\u9762\u5b50", 40, 30, 300);
                    break;
                }
                case 6: {
                    this.printInfo(g, "flag{RGFqaURhbGlfSmlud2FuQ2hpamk=}", 50, 150, 300);
                    break;
                }
            }
        }
    }

    public void printInfo(Graphics g, String str, int size, int x, int y) {
        Color c = g.getColor();
        g.setColor(Color.RED);
        Font f = new Font("\u5b8b\u4f53", 1, size);
        g.setFont(f);
        g.drawString(str, x, y);
        g.setColor(c);
    }

    public static void main(String[] args) {
        new PlaneGameFrame().launchFrame();
    }

    @Override
    public void launchFrame() {
        super.launchFrame();
        this.addKeyListener(new KeyMonitor());
        int i = 0;
        while (i < 60) {
            Bullet b = new Bullet();
            this.bulletList.add(b);
            ++i;
        }
        this.startTime = new Date();
    }

    class KeyMonitor
    extends KeyAdapter {
        KeyMonitor() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            System.out.println("\u6309\u4e0b:" + e.getKeyCode());
            switch (e.getKeyCode()) {
                case 37: {
                    PlaneGameFrame.this.p.left = true;
                    break;
                }
                case 38: {
                    PlaneGameFrame.this.p.up = true;
                    break;
                }
                case 39: {
                    PlaneGameFrame.this.p.right = true;
                    break;
                }
                case 40: {
                    PlaneGameFrame.this.p.down = true;
                    break;
                }
            }
            super.keyPressed(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            System.out.println("\u91ca\u653e:" + e.getKeyCode());
            switch (e.getKeyCode()) {
                case 37: {
                    PlaneGameFrame.this.p.left = false;
                    break;
                }
                case 38: {
                    PlaneGameFrame.this.p.up = false;
                    break;
                }
                case 39: {
                    PlaneGameFrame.this.p.right = false;
                    break;
                }
                case 40: {
                    PlaneGameFrame.this.p.down = false;
                    break;
                }
            }
            super.keyReleased(e);
        }
    }
}

